/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import javax.annotation.Nonnull;
import net.minecraft.util.text.Style;

public class VanillaTextKey {
    private CharSequence str;
    private int style;
    private int hash;

    public VanillaTextKey() {
    }

    private VanillaTextKey(@Nonnull CharSequence str, int style, int hash) {
        this.str = str.toString();
        this.style = style;
        this.hash = hash;
    }

    public void updateKey(CharSequence str, @Nonnull Style style) {
        this.str = str;
        this.style = VanillaTextKey.hashStyle(style);
        this.hash = 0;
    }

    public static int hashStyle(@Nonnull Style style) {
        if (style == Style.field_240709_b_) {
            return 0;
        }
        int r = 0;
        if (style.func_240711_a_() != null) {
            r |= style.func_240711_a_().func_240742_a_();
        }
        if (style.func_150223_b()) {
            r |= 0x1000000;
        }
        if (style.func_150242_c()) {
            r |= 0x2000000;
        }
        if (style.func_150236_d()) {
            r |= 0x4000000;
        }
        if (style.func_150234_e()) {
            r |= 0x8000000;
        }
        if (style.func_150233_f()) {
            r |= 0x10000000;
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this.style != ((VanillaTextKey)o).style) {
            return false;
        }
        CharSequence other = ((VanillaTextKey)o).str;
        int length = this.str.length();
        if (length != other.length()) {
            return false;
        }
        boolean formatting = false;
        for (int index = 0; index < length; ++index) {
            char c2;
            char c1 = this.str.charAt(index);
            if (c1 != (c2 = other.charAt(index)) && (c1 > '9' || c1 < '0' || formatting || c2 > '9' || c2 < '0')) {
                return false;
            }
            formatting = c1 == '\u00a7';
        }
        return true;
    }

    public int hashCode() {
        int code = this.hash;
        if (code == 0) {
            int length = this.str.length();
            boolean formatting = false;
            for (int index = 0; index < length; ++index) {
                int c = this.str.charAt(index);
                if (c <= 57 && c >= 48 && !formatting) {
                    c = 48;
                }
                code = code * 31 + c;
                formatting = c == 167;
            }
            this.hash = code * 31 + this.style;
            return this.hash;
        }
        return code;
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }

    public VanillaTextKey copy() {
        return new VanillaTextKey(this.str, this.style, this.hash);
    }
}

